<?php

namespace App\Livewire\Admin;

use Livewire\Component;
use Livewire\WithPagination;
use App\Models\Comment;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;

class AdminCommentComponent extends Component
{
    use WithPagination;

    public $perPage = 10;
    public $successMessage = '';
    public $errorMessage = '';

    public function approve($commentId)
    {
        DB::beginTransaction();
        try {
            $comment = Comment::findOrFail($commentId);
            $comment->approved = true;
            $comment->save();
            DB::commit();
            Log::info('Comment approved', ['comment_id' => $commentId, 'approved' => $comment->approved]);
            $this->successMessage = 'Comment approved successfully.';
            $this->resetPage();
            $this->dispatch('page-updated');
        } catch (\Exception $e) {
            DB::rollBack();
            Log::error('Comment approval failed: ' . $e->getMessage());
            $this->errorMessage = 'Failed to approve comment.';
        }
    }

    public function reject($commentId)
    {
        DB::beginTransaction();
        try {
            $comment = Comment::findOrFail($commentId);
            $comment->delete();
            DB::commit();
            Log::info('Comment rejected', ['comment_id' => $commentId]);
            $this->successMessage = 'Comment rejected successfully.';
            $this->resetPage();
            $this->dispatch('page-updated');
        } catch (\Exception $e) {
            DB::rollBack();
            Log::error('Comment rejection failed: ' . $e->getMessage());
            $this->errorMessage = 'Failed to reject comment.';
        }
    }

    public function clearMessages()
    {
        $this->successMessage = '';
        $this->errorMessage = '';
    }

    public function render()
    {
        $comments = Comment::with(['blog'])->orderBy('created_at', 'desc')->paginate($this->perPage);
        return view('livewire.admin.admin-comment-component', compact('comments'))
            ->layout('layouts.adminbase');
    }
}