<?php

namespace App\Livewire\Admin;

use Livewire\Component;
use App\Models\Blog;
use App\Models\Job;
use App\Models\JobApplication;
class AdminDashboardComponent extends Component
{

    public $totalBlogs = 0;
    public $totalJobs = 0;
    public $totalApplications = 0;
    public $recentBlogs = [];
    public $recentJobs = [];
    public $recentApplications = [];

    public function mount()
    {
        $this->totalBlogs = Blog::count();
        $this->totalJobs = Job::where('status', 'active')->count();
        $this->totalApplications = JobApplication::count();

        $this->recentBlogs = Blog::with('category', 'user')
            ->orderBy('created_at', 'desc')
            ->take(5)
            ->get();

        $this->recentJobs = Job::with('user')
            ->where('status', 'active')
            ->orderBy('created_at', 'desc')
            ->take(5)
            ->get();

        $this->recentApplications = JobApplication::with('job')
            ->orderBy('created_at', 'desc')
            ->take(5)
            ->get();
    }

    public function render()
    {
        return view('livewire.admin.admin-dashboard-component')->layout('layouts.adminbase');
    }
}
