<?php

namespace App\Livewire\Admin;

use App\Models\JobApplication;
use Livewire\Component;
use Livewire\WithPagination;

class AdminHealthcareJobApplicationComponent extends Component
{
    use WithPagination;

    public $perPage = 10;

    public function render()
    {
        $applications = JobApplication::with('job')
            ->whereHas('job', function ($query) {
                $query->where('department', 'Healthcare');
            })
            ->orderBy('created_at', 'desc')
            ->paginate($this->perPage);

        return view('livewire.admin.admin-healthcare-job-application-component', compact('applications'))
            ->layout('layouts.adminbase');
    }
}
