<?php

namespace App\Livewire;

use Livewire\Component;
use Livewire\WithPagination;
use App\Models\Blog;

class BlogsComponent extends Component
{
    use WithPagination;
    
    public $tag;

    protected $queryString = ['tag'];

    public function render()
    {
        $query = Blog::with(['category', 'user'])->withCount(['comments' => function ($query) {
            $query->where('approved', true);
        }])->latest();
        
        if ($this->tag) {
            $query->where('meta_keywords', 'LIKE', '%' . $this->tag . '%');
        }

        $blogs = $query->paginate(12);
        return view('livewire.blogs-component', ['blogs' => $blogs])->layout('components.layouts.base');
    }
}
