<?php

namespace App\Livewire;

use Livewire\Component;

class HomeComponent extends Component
{
    public $name;
    public $email;
    public $phone;
    public $message;
    public $selected_machines = [];

    public function mount()
    {
        $this->selected_machines = [];
    }

    public function submitQuote()
    {
        $this->validate([
            'name' => 'required',
            'email' => 'required|email',
            'phone' => 'required',
            'message' => 'required',
            'selected_machines' => 'required|array|min:1',
        ]);

        session()->flash('message', 'Quote request submitted successfully!');
        $this->reset(['name', 'email', 'phone', 'message', 'selected_machines']);
    }

    public function render()
    {
        $machines = [
            [
                'id' => 'excavators',
                'title' => 'Excavators',
                'category' => 'Heavy Duty',
                'image' => '/assets/images/Excavators.jpg',
            ],
            [
                'id' => 'payloaders',
                'title' => 'Payloaders',
                'category' => 'Heavy Duty',
                'image' => '/assets/images/payloader.jpg',
            ],
            [
                'id' => 'graders',
                'title' => 'Graders',
                'category' => 'Construction',
                'image' => '/assets/images/grader.jpg',
            ],
            [
                'id' => 'rollers',
                'title' => 'Vibrating Rollers',
                'category' => 'Road Work',
                'image' => '/assets/images/Vibrating_Roller.png',
            ],
            [
                'id' => 'cranes',
                'title' => 'Cranes',
                'category' => 'Lifting',
                'image' => '/assets/images/crane-construction-site.jpg',
            ],
            [
                'id' => 'lowbeds',
                'title' => 'Lowbeds',
                'category' => 'Transport',
                'image' => '/assets/images/low_bed.jpeg',
            ],
            [
                'id' => 'scaffolding',
                'title' => 'Scaffolding',
                'category' => 'Construction Support',
                'image' => '/assets/images/scalfolding.jpg',
            ],
            [
                'id' => 'bulldozer',
                'title' => 'Bulldozer',
                'category' => 'Earth Moving',
                'image' => '/assets/images/bulldozer.jpg',
            ],
            [
                'id' => 'building_materials',
                'title' => 'Building Materials',
                'category' => 'Supply',
                'image' => '/assets/images/building-materials.jpg',
            ],
        ];

        return view('livewire.home-component', ['machines' => $machines])->layout('components.layouts.base');
    }
}
