<?php

namespace App\Livewire;

use Livewire\Component;

class MachinesComponent extends Component
{
    public $name;
    public $email;
    public $phone;
    public $message;
    public $selected_machines = [];

    public function mount()
    {
        $this->selected_machines = [];
    }

    public function submitQuote()
    {
        // Validation (can be added later)
        $this->validate([
            'name' => 'required',
            'email' => 'required|email',
            'phone' => 'required',
            'message' => 'required',
            'selected_machines' => 'required|array|min:1',
        ]);

        // Logic to send email would go here
        // For now, we will just simulate a success message
        session()->flash('message', 'Quote request submitted successfully!');
        
        // Reset form
        $this->reset(['name', 'email', 'phone', 'message', 'selected_machines']);
    }

    public $categoryFilter;

    public function render()
    {
        $query = \App\Models\Equipment::query()->where('status', '!=', 'maintenance');

        if($this->categoryFilter) {
            $query->where('category_id', $this->categoryFilter);
        }

        $equipments = $query->paginate(9);
        $categories = \App\Models\Category::all();

        return view('livewire.machines-component', ['machines' => $equipments, 'categories' => $categories])->layout('components.layouts.base');
    }
}
