<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Job extends Model
{
    protected $fillable = [
        'title',
        'location',
        'description',
        'department',
        'employment_type',
        'minimum_experience',
        'salary',
        'status',
        'posted_by',
    ];

    protected $casts = [
        'status' => 'string',
    ];

    public function applications()
    {
        return $this->hasMany(JobApplication::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'posted_by');
    }
}
