<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('comments', function (Blueprint $table) {
            // Add approved column if it doesn't exist
            if (!Schema::hasColumn('comments', 'approved')) {
                $table->boolean('approved')->default(false);
            }
            // Rename 'message' to 'content' if it exists, or ensure 'content' exists
            if (Schema::hasColumn('comments', 'message') && !Schema::hasColumn('comments', 'content')) {
                $table->renameColumn('message', 'content');
            } elseif (!Schema::hasColumn('comments', 'content')) {
                $table->text('content');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('comments', function (Blueprint $table) {
            $table->dropColumn('approved');
            if (Schema::hasColumn('comments', 'content')) {
                $table->renameColumn('content', 'message');
            }
        });
    }
};
