<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('jobs', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('location')->nullable();
            $table->text('description');
            $table->string('department')->nullable();
            $table->enum('employment_type', ['full-time', 'part-time', 'contract', 'temporary'])->nullable();
            $table->string('minimum_experience')->nullable();
            $table->string('salary')->nullable();
            $table->enum('status', ['active', 'closed'])->default('active');
            $table->foreignId('posted_by')->constrained('users')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('jobs');
    }
};
