<x-authbase-layout>
    <main class="main-content mt-0">
        <div class="page-header align-items-start min-height-300 m-3 border-radius-xl" style="background-image: url('/assets/images/banner-slider-img/slider3.jpg');">
            <span class="mask bg-gradient-dark opacity-6"></span>
        </div>
        <div class="container mb-4">
            <div class="row mt-lg-n12 mt-md-n12 mt-n12 justify-content-center">
                <div class="col-xl-4 col-lg-5 col-md-7 mx-auto">
                    <div class="card mt-8">
                        <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
                            <div class="bg-gradient-success shadow-dark border-radius-lg py-3 pe-1 text-center py-4">
                                <h4 class="font-weight-bolder text-white mt-1">Create an account</h4>
                                <p class="mb-1 text-sm text-white">Enter your email and password to register</p>
                            </div>
                        </div>
                        <div class="card-body">
                            <form method="POST" action="{{ route('register') }}">
                                @csrf
                                <div class="input-group input-group-static mb-4">
                                    <label>Name</label>
                                    <input type="text" class="form-control" name="name" :value="old('name')" required autofocus autocomplete="name" placeholder="John Doe">
                                </div>
                                <div class="input-group input-group-static mb-4">
                                    <label>Email</label>
                                    <input type="email" class="form-control" name="email" :value="old('email')" required autocomplete="username" placeholder="dumescoastal@gmail.com">
                                </div>
                                <div class="input-group input-group-static mb-4">
                                    <label>Password</label>
                                    <input type="password" class="form-control" name="password" required autocomplete="new-password" placeholder="•••••••••••••">
                                </div>
                                <div class="input-group input-group-static mb-4">
                                    <label>Confirm Password</label>
                                    <input type="password" class="form-control" name="password_confirmation" required autocomplete="new-password" placeholder="•••••••••••••">
                                </div>

                                @if (Laravel\Jetstream\Jetstream::hasTermsAndPrivacyPolicyFeature())
                                    <div class="form-check form-check-info text-start ps-0">
                                        <input class="form-check-input" type="checkbox" name="terms" id="terms" required>
                                        <label class="form-check-label" for="terms">
                                            I agree the <a href="{{ route('terms.show') }}" class="text-dark font-weight-bolder" target="_blank">Terms and Conditions</a>
                                        </label>
                                    </div>
                                @endif

                                <div class="text-center">
                                    <button type="submit" class="btn btn-lg bg-dark text-white w-100 mt-4 mb-0">Sign Up</button>
                                </div>
                            </form>
                        </div>
                        <div class="card-footer text-center pt-0 px-lg-2 px-1">
                            <p class="mb-4 text-sm mx-auto">
                                Already have an account?
                                <a href="{{ route('login') }}" class="text-primary font-weight-bold">Sign In</a>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
</x-authbase-layout>
