@props(['submit'])
<div {{ $attributes->merge(['class' => 'row']) }}>
    <div class="col-md-4">
        <x-section-title>
            <x-slot name="title">{{ $title }}</x-slot>
            <x-slot name="description">{{ $description }}</x-slot>
        </x-section-title>
    </div>

    <div class="col-md-8">
        <form wire:submit="{{ $submit }}">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        {{ $form }}
                    </div>
                </div>

                @if (isset($actions))
                    <div class="card-footer d-flex justify-content-end bg-light">
                        {{ $actions }}
                    </div>
                @endif
            </div>
        </form>
    </div>
</div>
