@php
    $current_route = Route::currentRouteName();
    $seo_field = App\Models\SeoField::where('name_route', $current_route);
    
    if($current_route == 'single-blog' && isset($blog)){
        $seo_field->where('blog_id', $blog->id ?? '');
    }

    $seo_field = $seo_field->firstOrNew();
@endphp

@if (!empty($seo_field['meta_title']))
    <title>{{ $seo_field['meta_title'] }}</title>
@else
    <title>QCM Transport - Secure Patient Transport Services</title>
@endif
<meta name="keywords" content="{{ $seo_field['meta_keywords'] ?? '' }}">
<meta name="description" content="{{ $seo_field['meta_description'] ?? '' }}">
<meta name="robots" content="{{ $seo_field['meta_robot'] ?? '' }}">
<link rel="canonical" href="{{ $seo_field['canonical_url'] ?? '' }}" />
<link rel="custom" href="{{ $seo_field['custom_url'] ?? '' }}" />

<script type="application/ld+json">{!! $seo_field['json_ld'] !!}</script>

<meta property="og:title" content="{{ $seo_field['og_title'] ?? '' }}" />
<meta property="og:description" content="{{ $seo_field['og_description'] ?? '' }}" />
<meta property="og:image" content="{{ $seo_field['og_image'] ?? ($blog->image ?? '') }}" />
<meta property="og:url" content="{{ url()->current() }}" />