<div>
    <div class="container-fluid py-2">
        <div class="row mt-4">
            <div class="col-12">
            @if (session('message'))
                <div class="alert alert-success alert-dismissible fade show text-white" role="alert">
                    {{ session('message') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            @if (session('error'))
                <div class="alert alert-danger alert-dismissible fade show text-white" role="alert">
                    {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <h5 class="mb-0">All Blogs</h5>
                        <a href="{{ route('admin-blog-create') }}" class="btn btn-success py-2 px-3">Add New Blog</a>
                    </div>


                    <div class="table-responsive">
                        <table class="table table-flush table-striped table-hover table-bordered" id="datatable-search">
                            <thead class="thead-light">
                                <tr>
                                    <th class="text-center">Title</th>
                                    <th class="text-center">Category</th>
                                    <th class="text-center">Author</th>
                                    <th class="text-center">Date Created</th>
                                    <th class="text-center">Featured Image</th>
                                    <th class="text-center">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($blogs as $blog)
                                    <tr>
                                        <td class="text-sm font-weight-normal text-center">{{ $blog->title }}</td>
                                        <td class="text-sm font-weight-normal text-center">{{ $blog->category->name }}</td>
                                        <td class="text-sm font-weight-normal text-center">{{ $blog->user->name }}</td>
                                        <td class="text-sm font-weight-normal text-center">{{ $blog->created_at->format('d M, Y') }}</td>
                                        <td class="text-center">
                                            @if($blog->image)
                                                <img src="{{ $blog->image }}" width="50" class="img-thumbnail">
                                            @endif
                                        </td>
                                        <td class="text-sm text-center font-weight-normal">
                                            <a href="{{ route('admin-blog-edit', $blog->id) }}" class="btn btn-sm btn-icon-only text-light" 
                                               data-toggle="tooltip" data-original-title="Edit blog">
                                                <i class="bi bi-pencil fs-6 text-success"></i>
                                            </a>
                                            <a href="#" wire:click="delete({{ $blog->id }})" onclick="confirm('Are you sure you want to delete this News?') || event.stopImmediatePropagation()" class="btn btn-sm btn-icon-only text-light" 
                                               data-toggle="tooltip" data-original-title="Delete blog">
                                                <i class="bi bi-trash fs-6 text-danger"></i>
                                            </a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
        <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
        
        <script>
            $(document).ready(function() {
                // Initialize DataTable
                const dataTableSearch = new simpleDatatables.DataTable("#datatable-search", {
                    searchable: true,
                        fixedHeight: true,
                        perPage: 10,
                        perPageSelect: [5, 10, 25, 50],
                        labels: {
                            placeholder: "Search...",
                            perPage: "{select} entries per page",
                            noRows: "No entries found",
                            info: "Showing {start} to {end} of {rows} entries"
                        }
                });
            });
        </script>
    @endpush
</div>