<div>
    <link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">
    <script src="https://cdn.quilljs.com/1.3.6/quill.js"></script>

    <style>
        .note-editable {
            min-height: 200px;
            font-size: 16px;
        }
    </style>

    <div class="container-fluid py-2">
        <div class="row mt-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <h5 class="mb-0">{{ $isEdit ? 'Edit Blog' : 'Add New Blog' }}</h5>
                        <a href="{{ route('admin-blog') }}" class="btn btn-secondary py-2 px-3">Back to Blogs</a>
                    </div>
                    
                    <div class="card-body p-4">
                        <div class="mb-3">
                            <label class="form-label fw-semibold">Title</label>
                            <input wire:model="title" type="text" class="form-control border p-2" placeholder="Enter blog title">
                            @error('title') <div class="text-danger mt-1 small">{{ $message }}</div> @enderror
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-semibold">Category</label>
                            <select wire:model="category_id" class="form-select border p-2">
                                <option value="">Select Category</option>
                                @foreach($categories as $category)
                                    <option value="{{ $category->id }}">{{ $category->name }}</option>
                                @endforeach
                            </select>
                            @error('category_id') <div class="text-danger mt-1 small">{{ $message }}</div> @enderror
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-semibold">Content</label>
                            <div wire:ignore>
                                <div id="editor" style="height: 300px;"></div>
                            </div>
                            @error('content') <div class="text-danger mt-1 small">{{ $message }}</div> @enderror
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-semibold">Featured Image</label>
                            <input wire:model="image" type="file" class="form-control border p-2">
                            @error('image') <div class="text-danger mt-1 small">{{ $message }}</div> @enderror
                            @if($image)
                                <img src="{{ $image->temporaryUrl() }}" width="120" class="mt-2">
                            @elseif($existingImage)
                                <img src="{{ $existingImage }}" width="120" class="mt-2">
                            @endif
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-semibold">Meta Title</label>
                            <input wire:model="meta_title" type="text" class="form-control border p-2" placeholder="Enter blog meta title">
                            @error('meta_title') <div class="text-danger mt-1 small">{{ $message }}</div> @enderror
                            <span>0/200 characters</span>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-semibold">Meta Description</label>
                            <textarea wire:model="meta_description" class="form-control border p-2" rows="5" ></textarea>
                            @error('meta_description') <div class="text-danger mt-1 small">{{ $message }}</div>
                            @enderror
                        </div>
                            <div class="mb-3">
                            <label class="form-label fw-semibold">Meta Keywords (seperate with comma)</label>
                            <input wire:model="meta_keywords" type="text" class="form-control border p-2" placeholder="Enter meta keywords">
                            @error('meta_keywords') <div class="text-danger mt-1 small">{{ $message }}</div> @enderror
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-semibold">Meta Robot</label>
                            <input wire:model="meta_robot" type="text" class="form-control border p-2" placeholder="Enter meta robot">
                            @error('meta_robot') <div class="text-danger mt-1 small">{{ $message }}</div> @enderror
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-semibold">Canonical URL</label>
                            <input wire:model="canonical_url" type="text" class="form-control border p-2" placeholder="Enter canonical URL">
                            @error('canonical_url') <div class="text-danger mt-1 small">{{ $message }}</div> @enderror
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-semibold">Custom URL</label>
                            <input wire:model="custom_url" type="text" class="form-control border p-2" placeholder="Enter custom URL">
                            @error('custom_url') <div class="text-danger mt-1 small">{{ $message }}</div> @enderror
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-semibold">JSON-LD</label>
                            <textarea wire:model="json_ld" class="form-control border p-2" rows="5" ></textarea>
                            @error('json_ld') <div class="text-danger mt-1 small">{{ $message }}</div> @enderror
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-semibold">OG Title</label>
                            <input wire:model="og_title" type="text" class="form-control border p-2" placeholder="Enter OG title">
                            @error('og_title') <div class="text-danger mt-1 small">{{ $message }}</div> @enderror
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-semibold">OG Description</label>
                            <textarea wire:model="og_description" class="form-control border p-2" rows="5" ></textarea>
                            @error('og_description') <div class="text-danger mt-1 small">{{ $message }}</div> @enderror
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-semibold">OG Image</label>
                            <input wire:model="og_image" type="text" class="form-control border p-2" placeholder="Enter OG image URL">
                            @error('og_image') <div class="text-danger mt-1 small">{{ $message }}</div> @enderror
                        </div>

                    </div>

                    <div class="card-footer d-flex justify-content-end px-4 pb-4">
                        <button type="button" id="save-button" class="btn btn-success" wire:loading.attr="disabled">
                            <span wire:loading.remove>Save Blog</span>
                            <span wire:loading>Saving...</span>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script>
            document.addEventListener('livewire:initialized', () => {
                var quill = new Quill('#editor', {
                    theme: 'snow',
                    modules: {
                        toolbar: [
                            [{ 'header': [1, 2, 3, 4, 5, 6, false] }],
                            ['bold', 'italic', 'underline', 'strike'],
                            ['blockquote', 'code-block'],
                            [{ 'list': 'ordered'}, { 'list': 'bullet' }],
                            [{ 'script': 'sub'}, { 'script': 'super' }],
                            [{ 'indent': '-1'}, { 'indent': '+1' }],
                            [{ 'direction': 'rtl' }],
                            [{ 'size': ['small', false, 'large', 'huge'] }],
                            [{ 'color': [] }, { 'background': [] }],
                            [{ 'font': [] }],
                            [{ 'align': [] }],
                            ['clean'],
                            ['link', 'image', 'video']
                        ]
                    }
                });

                // Load initial content
                var initialContent = {!! json_encode($content) !!};
                if (initialContent) {
                    quill.root.innerHTML = initialContent;
                }
                 // Handle livewire re-renders preserving content if needed, but since we use wire:ignore this is mostly for initial load.
                 // Actually, if validation fails, we want to keep the content. Livewire might reset standard inputs but the ignore div won't update.
                 // However, we need to ensure if the component updates from server (e.g. after save failure?), the editor content is preserved.
                 // But since we are setting content manually on save, it should be fine.

                quill.getModule('toolbar').addHandler('image', function() {
                    selectLocalImage();
                });

                function selectLocalImage() {
                    const input = document.createElement('input');
                    input.setAttribute('type', 'file');
                    input.setAttribute('accept', 'image/*');
                    input.click();

                    input.onchange = function() {
                        const file = input.files[0];
                        if (/^image\//.test(file.type)) {
                            saveToServer(file);
                        } else {
                            console.warn('You could only upload images.');
                        }
                    };
                }

                function saveToServer(file) {
                    @this.upload('contentImage', file, (uploadedFilename) => {
                        // We don't need to do anything here, as the backend will handle the URL.
                    });
                }

                window.addEventListener('content-image-uploaded', event => {
                    insertToEditor(event.detail.url);
                });

                function insertToEditor(url) {
                    const range = quill.getSelection();
                    quill.insertEmbed(range.index, 'image', url);
                }

                document.getElementById('save-button').addEventListener('click', function () {
                    @this.set('content', quill.root.innerHTML);
                    @this.call('save');
                });
            });
        </script>
    @endpush
</div>
