<div>
    <!-- Include Bootstrap and DataTables CSS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/jquery.dataTables.min.css">

    <div class="container-fluid py-2">
        <div class="row mt-4">
            <div class="col-12">
            @if (session('message'))
                <div class="alert alert-success alert-dismissible fade show text-white" role="alert">
                    {{ session('message') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            @if (session('error'))
                <div class="alert alert-danger alert-dismissible fade show text-white" role="alert">
                    {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif
                <div class="card">
                    <!-- Card header -->
                    <div class="card-header d-flex justify-content-between">
                        <h5 class="mb-0">All Blog Categories</h5>
                        <button wire:click="openModal" class="btn btn-primary-custom py-2 px-3">Add New Category</button>
                    </div>

                    <!-- Modal -->
                    <div wire:ignore.self class="modal fade" id="exampleModal" tabindex="-1" role="dialog" 
                         aria-labelledby="exampleModalLabel" aria-hidden="{{ $showModal ? 'false' : 'true' }}">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title font-weight-normal" id="exampleModalLabel">
                                        {{ $isEdit ? 'Edit Category' : 'Add Category' }}
                                    </h5>
                                    <button type="button" class="btn-close text-dark" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                   
                                    <div class="mb-3">
                                        <label class="form-label fw-semibold">Name</label>
                                        <input wire:model="name" type="text" class="form-control border p-2" placeholder="Enter category name">
                                        @error('name') <div class="text-danger mt-1 small">{{ $message }}</div> @enderror
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn bg-gradient-secondary" data-bs-dismiss="modal">Close</button>
                                    <button type="button" wire:click="save" class="btn bg-primary text-white">Save changes</button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-flush table-striped table-hover table-bordered" id="datatable-search">
                            <thead class="thead-light">
                                <tr>
                                    <th class="text-center">Name</th>
                                    <th class="text-center">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($categories as $category)
                                    <tr>
                                        <td class="text-sm font-weight-normal text-center ">{{ $category->name }}</td>
                                        <td class="text-sm text-center font-weight-normal">
                                            <!-- Edit Icon -->
                                            <a href="#" wire:click="openModal({{ $category->id }})"
                                               class="btn btn-sm btn-icon-only text-light" 
                                               data-toggle="tooltip" 
                                               data-original-title="Edit category">
                                                <i class="bi bi-pencil fs-6 text-primary-custom"></i>
                                            </a>
                                            <!-- Delete Icon -->
                                            <a href="#" wire:click="delete({{ $category->id }})"
                                               class="btn btn-sm btn-icon-only text-light" 
                                               data-toggle="tooltip" 
                                               data-original-title="Delete category">
                                                <i class="bi bi-trash fs-6 text-danger"></i>
                                            </a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        @push('scripts')
            <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
            <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
            <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
            <script>
                document.addEventListener('livewire:initialized', function () {
                    const dataTableSearch = new simpleDatatables.DataTable("#datatable-search", {
                        searchable: true,
                        fixedHeight: true,
                        perPage: 10,
                        perPageSelect: [5, 10, 25, 50],
                        labels: {
                            placeholder: "Search...",
                            perPage: "{select} entries per page",
                            noRows: "No entries found",
                            info: "Showing {start} to {end} of {rows} entries"
                        }
                    });
                });

                window.addEventListener('show-modal', event => {
                    const myModal = new bootstrap.Modal(document.getElementById('exampleModal'));
                    myModal.show();
                });

                window.addEventListener('hide-modal', event => {
                    const myModal = bootstrap.Modal.getInstance(document.getElementById('exampleModal'));
                    if (myModal) {
                        myModal.hide();
                    }
                });
            </script>
        @endpush
    </div>
</div>