<div>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/2.1.4/css/dataTables.bootstrap5.css">

    <div class="container-fluid py-4">
        <div class="row">
            <div class="col-12">
                
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">Manage Comments</h5>
                    </div>
                   <div class="col-md-8 text-center">
                    @if($successMessage)
                            <div class="alert alert-success alert-dismissible fade show text-white" role="alert">
                                {{ $successMessage }}
                                <button type="button" class="btn-close" wire:click="clearMessages"></button>
                            </div>
                        @endif
                        @if($errorMessage)
                            <div class="alert alert-danger alert-dismissible fade show text-white" role="alert">
                                {{ $errorMessage }}
                                <button type="button" class="btn-close" wire:click="clearMessages"></button>
                            </div>
                        @endif
                   </div>
                    <div class="table-responsive">
                        <table class="table table-flush table-striped table-hover table-bordered" id="datatable-comments">
                            <thead class="thead-light">
                                <tr>
                                    <th class="text-center">Blog Title</th>
                                    <th class="text-center">Commenter</th>
                                    <th class="text-center">Email</th>
                                    <th class="text-center">Content</th>
                                    <th class="text-center">Status</th>
                                    <th class="text-center">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($comments as $comment)
                                    <tr>
                                        <td class="text-sm text-center">{{ $comment->blog->title }}</td>
                                        <td class="text-sm text-center">{{ $comment->name }}</td>
                                        <td class="text-sm text-center"> {{ $comment->email }}</td>
                                        <td class="text-sm text-center">{{ Str::limit($comment->content, 50) }}</td>
                                        <td class="text-sm text-center">{{ $comment->approved ? 'Approved' : 'Pending' }}</td>
                                        <td class="text-sm text-center">
                                            @if(!$comment->approved)
                                                <button wire:click="approve({{ $comment->id }})" class="btn btn-sm btn-success"
                                                wire:loading.attr="disabled">
                                                    Approve
                                                </button>
                                                <button wire:click="reject({{ $comment->id }})" class="btn btn-sm btn-danger"
                                                wire:loading.attr="disabled">
                                                    Reject
                                                </button>
                                            @else
                                                <span class="text-muted">Approved</span>
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <div class="d-flex justify-content-center mt-4">
                        {{ $comments->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
        <script src="https://cdn.datatables.net/2.1.4/js/dataTables.min.js"></script>
        <script src="https://cdn.datatables.net/2.1.4/js/dataTables.bootstrap5.min.js"></script>
        <script>
            document.addEventListener('livewire:init', () => {
                let dataTable;
                function initDataTable() {
                    if (dataTable) {
                        dataTable.destroy();
                    }
                    dataTable = $('#datatable-comments').DataTable({
                        searching: true,
                        pageLength: 10,
                        lengthMenu: [5, 10, 25, 50],
                        language: {
                            searchPlaceholder: 'Search...',
                            lengthMenu: '_MENU_ entries per page',
                            emptyTable: 'No comments found',
                            info: 'Showing _START_ to _END_ of _TOTAL_ comments'
                        }
                    });
                }
                initDataTable();
                Livewire.on('component.updated', () => {
                    initDataTable();
                });
            });
        </script>
    @endpush
</div>