<div>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/jquery.dataTables.min.css">

    <div class="container-fluid py-4">
        <div class="row">
            <div class="col-12">
                @if (session('message'))
                    <div class="alert alert-success alert-dismissible fade show text-white" role="alert">
                        {{ session('message') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif

                @if (session('error'))
                    <div class="alert alert-danger alert-dismissible fade show text-white" role="alert">
                        {{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">Job Applications</h5>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-flush table-striped table-hover table-bordered" id="datatable-applications">
                            <thead class="thead-light">
                                <tr>
                                    <th>s/n</th>
                                    <th>Job Title</th>
                                    <th>Applicant</th>
                                    <th>Email</th>
                                    <th>Phone</th>
                                    <th>Resume</th>
                                    <th>Cover Letter</th>
                                    <th>Applied At</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($applications as $application)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $application->job->title }}</td>
                                        <td>{{ $application->first_name }} {{ $application->last_name }}</td>
                                        <td>{{ $application->email }}</td>
                                        <td>{{ $application->phone }}</td>
                                        <td>
                                            <button type="button" class="btn btn-sm btn-primary text-white" data-bs-toggle="modal" data-bs-target="#pdfModal{{ $application->id }}">
                                                View Resume
                                            </button>
                                            <!-- PDF Preview Modal -->
                                            <div class="modal fade" id="pdfModal{{ $application->id }}" tabindex="-1" aria-labelledby="pdfModalLabel{{ $application->id }}" aria-hidden="true">
                                                <div class="modal-dialog modal-lg">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="pdfModalLabel{{ $application->id }}">Resume - {{ $application->first_name }} {{ $application->last_name }}</h5>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <div id="pdfViewer{{ $application->id }}" class="pdf-viewer" style="height: 600px;">
                                                                <iframe src="https://docs.google.com/viewer?url={{ urlencode($application->resume_url) }}&embedded=true" width="100%" height="100%" style="border: none;"></iframe>
                                                            </div>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <button type="button" class="btn btn-sm bg-secondary px-4 text-white" data-bs-toggle="modal" data-bs-target="#coverLetterModal{{ $application->id }}">
                                                View
                                            </button>
                                            <div class="modal fade" id="coverLetterModal{{ $application->id }}" tabindex="-1" aria-hidden="true">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title">Cover Letter</h5>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                        </div>
                                                        <div class="modal-body">
                                                            {!! nl2br(e($application->cover_letter)) !!}
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                        <td>{{ $application->created_at->format('M d, Y') }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <div class="d-flex justify-content-center mt-4">
                        {{ $applications->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
        <script>
            document.addEventListener('livewire:initialized', function () {
                const dataTableSearch = new simpleDatatables.DataTable("#datatable-applications", {
                    searchable: true,
                    fixedHeight: true,
                    perPage: {{ $perPage }},
                    perPageSelect: [5, 10, 25, 50],
                    labels: {
                        placeholder: "Search...",
                        perPage: "{select} entries per page",
                        noRows: "No entries found",
                        info: "Showing {start} to {end} of {rows} entries"
                    }
                });

                Livewire.on('tableUpdated', () => {
                    dataTableSearch.destroy();
                    dataTableSearch = new simpleDatatables.DataTable("#datatable-applications", {
                        searchable: true,
                        fixedHeight: true,
                        perPage: {{ $perPage }},
                        perPageSelect: [5, 10, 25, 50],
                        labels: {
                            placeholder: "Search...",
                            perPage: "{select} entries per page",
                            noRows: "No entries found",
                            info: "Showing {start} to {end} of {rows} entries"
                        }
                    });
                });
            });
        </script>
    @endpush
</div>