
<div>
    <div class="container-fluid my-3 py-3">
        <div class="row mb-5">
            <div class="col-lg-3">
                <div class="card position-sticky top-1">
                    <ul class="nav flex-column bg-white border-radius-lg p-3">
                        <li class="nav-item">
                            <a class="nav-link text-dark d-flex" data-scroll="" href="#profile">
                                <i class="material-symbols-rounded text-lg me-2">person</i>
                                <span class="text-sm">Profile</span>
                            </a>
                        </li>
                        <li class="nav-item pt-2">
                            <a class="nav-link text-dark d-flex" data-scroll="" href="#basic-info">
                                <i class="material-symbols-rounded text-lg me-2">receipt_long</i>
                                <span class="text-sm">Basic Info</span>
                            </a>
                        </li>
                        <li class="nav-item pt-2">
                            <a class="nav-link text-dark d-flex" data-scroll="" href="#password">
                                <i class="material-symbols-rounded text-lg me-2">lock</i>
                                <span class="text-sm">Change Password</span>
                            </a>
                        </li>
                        <li class="nav-item pt-2">
                            <a class="nav-link text-dark d-flex" data-scroll="" href="#2fa">
                                <i class="material-symbols-rounded text-lg me-2">security</i>
                                <span class="text-sm">2FA</span>
                            </a>
                        </li>
                        <li class="nav-item pt-2">
                            <a class="nav-link text-dark d-flex" data-scroll="" href="#sessions">
                                <i class="material-symbols-rounded text-lg me-2">devices</i>
                                <span class="text-sm">Sessions</span>
                            </a>
                        </li>
                        <li class="nav-item pt-2">
                            <a class="nav-link text-dark d-flex" data-scroll="" href="#delete">
                                <i class="material-symbols-rounded text-lg me-2">delete</i>
                                <span class="text-sm">Delete Account</span>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="col-lg-9 mt-lg-0 mt-4">
            @if (session('message'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('message') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            @if (session('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif
                <!-- Profile Section -->
                <div class="card card-body" id="profile">
                    <div class="row justify-content-center align-items-center">
                        <div class="col-sm-auto col-4">
                            <div class="avatar avatar-xl position-relative">
                                <img src="{{ auth()->user()->profile_photo_url }}" alt="{{ auth()->user()->name }}" class="w-100 rounded-circle shadow-sm">
                            </div>
                        </div>
                        <div class="col-sm-auto col-8 my-auto">
                            <div class="h-100">
                                <h5 class="mb-1 font-weight-bolder">
                                    {{ auth()->user()->name }}
                                </h5>
                                <p class="mb-0 font-weight-normal text-sm">
                                    {{ auth()->user()->email }}
                                </p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Basic Info Section -->
                <div class="card mt-4" id="basic-info">
                    <div class="card-header">
                        <h5>Basic Info</h5>
                    </div>
                    <div class="card-body pt-0">
                        @livewire('profile.update-profile-information-form')
                    </div>
                </div>

                <!-- Change Password Section -->
                <div class="card mt-4" id="password">
                    <div class="card-header">
                        <h5>Change Password</h5>
                    </div>
                    <div class="card-body pt-0">
                        @livewire('profile.update-password-form')
                    </div>
                </div>

                <!-- Two-Factor Authentication Section -->
                <div class="card mt-4" id="2fa">
                    <div class="card-header d-flex">
                        <h5 class="mb-0">Two-factor authentication</h5>
                        <span class="badge bg-success ms-auto mb-auto">{{ auth()->user()->two_factor_secret ? 'Enabled' : 'Disabled' }}</span>
                    </div>
                    <div class="card-body">
                        @livewire('profile.two-factor-authentication-form')
                    </div>
                </div>

                <!-- Sessions Section -->
                <div class="card mt-4" id="sessions">
                    <div class="card-header pb-3">
                        <h5>Sessions</h5>
                        <p class="text-sm">This is a list of devices that have logged into your account. Remove those that you do not recognize.</p>
                    </div>
                    <div class="card-body pt-0">
                        @livewire('profile.logout-other-browser-sessions-form')
                    </div>
                </div>

                <!-- Delete Account Section -->
                <div class="card mt-4" id="delete">
                    <div class="card-body">
                        @livewire('profile.delete-user-form')
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
