<div>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/jquery.dataTables.min.css">

    <div class="container-fluid py-4">
        <div class="row">
            <div class="col-12">
                @if (session('message'))
                    <div class="alert alert-success alert-dismissible fade show text-white" role="alert">
                        {{ session('message') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif

                @if (session('error'))
                    <div class="alert alert-danger alert-dismissible fade show text-white" role="alert">
                        {{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">Administrators</h5>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-flush table-striped table-hover table-bordered" id="datatable-admins">
                            <thead class="thead-light">
                                <tr>
                                    <th>ID</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Role</th>
                                    <th>Created At</th>
                                    <!-- <th>Updated At</th> -->
                                    @can('manage-admins')
                                        <th>Update Role</th>
                                        <th>Actions</th>
                                    @endcan
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($admins as $admin)
                                    <tr>
                                        <td>{{ $admin->id }}</td>
                                        <td>{{ $admin->name }}</td>
                                        <td>{{ $admin->email }}</td>
                                        <td>{{ $admin->role }}</td>
                                        <td>{{ \Carbon\Carbon::parse($admin->created_at)->format('M d, Y H:i:s') }}</td>
                                        <!-- <td>{{ \Carbon\Carbon::parse($admin->updated_at)->format('M d, Y H:i:s') }}</td> -->
                                        @can('manage-admins')
                                            <td>
                                                <select wire:change="updateAdminRole({{ $admin->id }}, $event.target.value)" class="form-select form-select-sm">
                                                    <option value="admin" {{ $admin->role === 'admin' ? 'selected' : '' }}>Admin</option>
                                                    <option value="super_admin" {{ $admin->role === 'super_admin' ? 'selected' : '' }}>Super Admin</option>
                                                </select>
                                            </td>
                                            <td>
                                                <button wire:click="deleteAdmin({{ $admin->id }})" wire:confirm="Are you sure you want to delete this administrator?" class="btn btn-danger btn-sm mt-2">Delete</button>
                                            </td>
                                        @endcan
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <div class="d-flex justify-content-center mt-4">
                        {{ $admins->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
        <script>
            document.addEventListener('livewire:initialized', function () {
                const dataTableSearch = new simpleDatatables.DataTable("#datatable-admins", {
                    searchable: true,
                    fixedHeight: true,
                    perPage: {{ $perPage }},
                    perPageSelect: [5, 10, 25, 50],
                    labels: {
                        placeholder: "Search...",
                        perPage: "{select} entries per page",
                        noRows: "No entries found",
                        info: "Showing {start} to {end} of {rows} entries"
                    }
                });

                Livewire.on('tableUpdated', () => {
                    dataTableSearch.destroy();
                    dataTableSearch = new simpleDatatables.DataTable("#datatable-admins", {
                        searchable: true,
                        fixedHeight: true,
                        perPage: {{ $perPage }},
                        perPageSelect: [5, 10, 25, 50],
                        labels: {
                            placeholder: "Search...",
                            perPage: "{select} entries per page",
                            noRows: "No entries found",
                            info: "Showing {start} to {end} of {rows} entries"
                        }
                    });
                });
            });
        </script>
    @endpush
</div>