<?php

use App\Livewire\ContactComponent;
use App\Livewire\HomeComponent;
use App\Livewire\ServicesComponent;
use App\Livewire\ServiceDetailComponent;
use App\Livewire\MachinesComponent;
use App\Livewire\AboutComponent;
use App\Livewire\ProjectsComponent;
use App\Livewire\BlogsComponent;
use Illuminate\Support\Facades\Route;
use Laravel\Fortify\Features;





Route::get('/', HomeComponent::class)->name('home');
Route::get('/contact', ContactComponent::class)->name('contact');
Route::get('/about', AboutComponent::class)->name('about');
Route::get('/services', ServicesComponent::class)->name('services');
Route::get('/machines', MachinesComponent::class)->name('machines');
Route::get('/service/{slug}', ServiceDetailComponent::class)->name('service.detail');
Route::get('/projects', ProjectsComponent::class)->name('projects');
Route::get('/blogs', BlogsComponent::class)->name('blogs');
Route::get('/blog/{slug}', App\Livewire\BlogDetailComponent::class)->name('blog.detail');
Route::middleware([
    'auth:sanctum',
    config('jetstream.auth_session'),
    'verified',
])->group(function () {
    Route::get('/dashboard', function () {
        return view('dashboard');
    })->name('dashboard');

    // Admin Routes
    // Admin Routes
    Route::prefix('admin')->group(function () {
        Route::get('/dashboard', App\Livewire\Admin\AdminDashboardComponent::class)->name('admin-dashboard');
        Route::get('/blogs', App\Livewire\Admin\AdminBlogComponent::class)->name('admin-blog');
        Route::get('/blogs/create', App\Livewire\Admin\AdminBlogFormComponent::class)->name('admin-blog-create');
        Route::get('/blogs/{id}/edit', App\Livewire\Admin\AdminBlogFormComponent::class)->name('admin-blog-edit');
        Route::get('/categories', App\Livewire\Admin\AdminCategoryComponent::class)->name('admin-categories');
        Route::get('/comments', App\Livewire\Admin\AdminCommentComponent::class)->name('admin-comments');
        Route::get('/job-applications', App\Livewire\Admin\AdminJobApplicationComponent::class)->name('admin-job-applications');
        Route::get('/healthcare-job-applications', App\Livewire\Admin\AdminHealthcareJobApplicationComponent::class)->name('admin-healthcare-job-application');
        Route::get('/jobs', App\Livewire\Admin\AdminPostJobsComponent::class)->name('admin-jobs');
        Route::get('/profile', App\Livewire\Admin\AdminProfileSettingsComponent::class)->name('admin-profile');
        Route::get('/admins', App\Livewire\Admin\AdminsComponent::class)->name('admin-admins');
        Route::get('/equipment', App\Livewire\Admin\AdminEquipmentComponent::class)->name('admin.equipment');
        Route::get('/equipment/add', App\Livewire\Admin\AdminEquipmentFormComponent::class)->name('admin.equipment.add');
        Route::get('/equipment/edit/{slug}', App\Livewire\Admin\AdminEquipmentFormComponent::class)->name('admin.equipment.edit');
    });
});
