<?php
    $current_route = Route::currentRouteName();
    $seo_field = App\Models\SeoField::where('name_route', $current_route);
    
    if($current_route == 'single-blog' && isset($blog)){
        $seo_field->where('blog_id', $blog->id ?? '');
    }

    $seo_field = $seo_field->firstOrNew();
?>

<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($seo_field['meta_title'])): ?>
    <title><?php echo e($seo_field['meta_title']); ?></title>
<?php else: ?>
    <title>QCM Transport - Secure Patient Transport Services</title>
<?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
<meta name="keywords" content="<?php echo e($seo_field['meta_keywords'] ?? ''); ?>">
<meta name="description" content="<?php echo e($seo_field['meta_description'] ?? ''); ?>">
<meta name="robots" content="<?php echo e($seo_field['meta_robot'] ?? ''); ?>">
<link rel="canonical" href="<?php echo e($seo_field['canonical_url'] ?? ''); ?>" />
<link rel="custom" href="<?php echo e($seo_field['custom_url'] ?? ''); ?>" />

<script type="application/ld+json"><?php echo $seo_field['json_ld']; ?></script>

<meta property="og:title" content="<?php echo e($seo_field['og_title'] ?? ''); ?>" />
<meta property="og:description" content="<?php echo e($seo_field['og_description'] ?? ''); ?>" />
<meta property="og:image" content="<?php echo e($seo_field['og_image'] ?? ($blog->image ?? '')); ?>" />
<meta property="og:url" content="<?php echo e(url()->current()); ?>" /><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/Dumes/resources/views/layouts/seo/seo.blade.php ENDPATH**/ ?>